using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;
using VIRP.EFR.UTIL;

namespace VIRP.EFR.DAL
{
	public partial class PATIENT_IMAGE_REVIEWDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public PATIENT_IMAGE_REVIEWDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public PATIENT_IMAGE_REVIEW GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_REVIEW_ID)
		{
			PATIENT_IMAGE_REVIEW objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_PATIENT_IMAGE_REVIEW_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_REVIEW_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<PATIENT_IMAGE_REVIEW> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<PATIENT_IMAGE_REVIEW> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_PATIENT_IMAGE_REVIEW_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_IMAGE_REVIEW objSave)
		{
			Int32? objReturn = objSave.PATIENT_IMAGE_REVIEW_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_PATIENT_IMAGE_REVIEW_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENTS, DateTime.Now, objSave.CREATEDBY, objSave.DATE_REVIEWED_FLAG, objSave.FRAGMENT_VERIFIED_FLAG, objSave.IMAGE_REASON_OTHER_TEXT, objSave.IMAGE_TYPE_OTHER_TEXT, objSave.INCLUDE_IN_REPORT_FLAG, objSave.LARGEST_FRAGMENT_LENGTH, objSave.LARGEST_FRAGMENT_WIDTH, objSave.PATIENT_ID, objSave.PATIENT_IMAGE_ID, ref objReturn, objSave.REVIEWED_FLAG, objSave.SMALLEST_FRAGMENT_LENGTH, objSave.SMALLEST_FRAGMENT_WIDTH, objSave.STD_IMAGE_FRAGMENT_COUNT_ID, objSave.STD_IMAGE_TYPE_ID, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

        public int InsertUpdatePatientImageReview(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            PATIENT_IMAGE_REVIEW objSave,
            IReadOnlyList<int> imageBodyParts,
            IReadOnlyList<int> imagingReasons)
        {
            int? objReturn = objSave.PATIENT_IMAGE_REVIEW_ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    dbContext.usp_InsertUpdatePatientImageReview(
                        CURRENT_USER,
                        CURRENT_REGISTRY_ID,
                        objSave.PATIENT_ID,
                        objSave.PATIENT_IMAGE_ID,
                        ref objReturn,
                        objSave.STD_IMAGE_FRAGMENT_COUNT_ID,
                        objSave.STD_IMAGE_TYPE_ID,
                        objSave.FRAGMENT_VERIFIED_FLAG,
                        objSave.REVIEWED_FLAG,
                        objSave.INCLUDE_IN_REPORT_FLAG,
                        objSave.LARGEST_FRAGMENT_LENGTH,
                        objSave.LARGEST_FRAGMENT_WIDTH,
                        objSave.SMALLEST_FRAGMENT_LENGTH,
                        objSave.SMALLEST_FRAGMENT_WIDTH,
                        objSave.COMMENTS,
                        objSave.IMAGE_REASON_OTHER_TEXT,
                        objSave.IMAGE_TYPE_OTHER_TEXT,
                        StringUtility.GetCollectionAsSafeDelimitedString(imageBodyParts),
                        StringUtility.GetCollectionAsSafeDelimitedString(imagingReasons));

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_REVIEW_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_PATIENT_IMAGE_REVIEW_delete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_REVIEW_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
